<?php
/**
* Related Linkz WYSIWYG button plugin
* @package Attachments
* @Copyright (C) 2009 Alan Sparkes, All Rights Reserved
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
* @link http://www.joomkit.com/
* @author Alan Sparkes
**/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.event.plugin');


class plgButtonadd_relatedlinkz extends JPlugin
{
    /**
     * Constructor
     *
     * For php4 compatability we must not use the __constructor as a constructor for plugins
     * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
     * This causes problems with cross-referencing necessary for the observer design pattern.
     *
     * @param       object $subject The object to observe
     * @param       array  $config  An array that holds the plugin configuration
     * @since 1.5
     */
    function plgadd_relatedlinkz(& $subject, $config)
    {
        parent::__construct($subject, $config);
    }

    /**
     * Add relatedlink button
     *
     * @return a button
     */
    function onDisplay($name)
    {   
        // Avoid displaying the button for anything except content articles
        global $option;
        if ( $option != 'com_content' ) {
            return new JObject();
            }
 
        // Get the article ID
        $cid = JRequest::getVar( 'cid', array(0), '', 'array');
        $article_id = 0;
        if ( count($cid) > 0 ) {
            $article_id = intval($cid[0]);
            }
        if ( $article_id == 0) {
            $nid = JRequest::getVar( 'id', null);
            if ( !is_null($nid) ) {
                $article_id = intval($nid);
                }
            }
        // echo "ooo" . $article_id;
        // Create the button object
        $button = new JObject();
            
        // Load the language file from the backend
        $lang = & JFactory::getLanguage();
        $lang->load('com_relatedlinkz', JPATH_ADMINISTRATOR);
        // ??? Where is the tooltip coming from?
        // (Would like to use different tip for create article button)

        // Figure out where we are and construct the right link and set
        // up the style sheet (to get the visual for the button working)
        global $mainframe;
        $doc =& JFactory::getDocument();
        if ( $mainframe->isAdmin() ) {
            if ( $article_id == 0 ) {
                // New article, explain that we can't add relatedlinks until it is saved
                
                // Load the language file from the frontend
                $lang = & JFactory::getLanguage();
                $lang->load('com_relatedlinkz', JPATH_SITE);
                
                // Save the warning message for the pop-up window
                //require_once(JPATH_BASE.DS.'..'.DS.'components'.DS.'com_relatedlinkz'.DS.'helpers'.DS.'helper.php');

                $msg = JText::_('SAVE ARTICLE BEFORE ADDING RELATED LINK')."  ".JText::_('TRY APPLY BUTTON FIRST');
                //relatedlinksHelper::save_warning_message($msg);

                $button->set('options', "{handler: 'iframe', size: {x: 400, y: 300}}");
                $link = "index.php?option=com_relatedlinkz&task=warning&tmpl=component";
                }
            else
                {
                $button->set('options', "{handler: 'iframe', size: {x: 800, y: 530}}");
                $link = "index.php?option=com_relatedlinkz&task=default&tabStart=0&article_id=$article_id&tmpl=component";
                }
                $doc->addStyleSheet( $mainframe->getSiteURL() . 'plugins/editors-xtd/add_relatedlinkz.css',
                                 'text/css', null, array() );
            }
        else {
            if ( $article_id == 0 ) {
                // Load the language file from the frontend
                $lang = & JFactory::getLanguage();
                $lang->load('com_relatedlinks', JPATH_SITE);

                // Save the warning message for the pop-up window
                require_once(JPATH_BASE.DS.'components'.DS.'com_relatedlinks'.DS.'helper.php');
                $msg = JText::_('SAVE ARTICLE BEFORE ADDING LINK');
                relatedlinksHelper::save_warning_message($msg);

                // New article, explain we can't add relatedlinks until it is saved
                $button->set('options', "{handler: 'iframe', size: {x: 400, y: 300}}");
                $link = "index.php?option=com_relatedlinks&task=warning&tmpl=component";
                }
            else {
                $button->set('options', "{handler: 'iframe', size: {x: 700, y: 530}}");
                $link = "index.php?option=com_relatedlinks&task=upload&artid=$id&from=closeme";
                }
            $doc->addStyleSheet( JURI::Base() . 'plugins/editors-xtd/relatedlinkz/css/add_relatedlinkz.css',
                                 'text/css', null, array() );
            }

        $button->set('modal', true);
        $button->set('class', 'modal');
        $button->set('text', JText::_('ADD RELATED LINK'));
        $button->set('name', 'add_relatedlinkz');
        $button->set('link', $link);
        $button->set('image', 'add_relatedlinkz.png');

        return $button;
    }
}
?>
